<?php

namespace App\Livewire\Kot;

use App\Models\Kot;
use App\Models\KotItem;
use Livewire\Component;

class KotCard extends Component
{
    public $kot;
    public $confirmDeleteKotModal = false;

    public function changeKotStatus($status)
    {
        Kot::where('id', $this->kot->id)->update([
            'status' => $status
        ]);

        if ($status == 'food_ready') {
           KotItem::where('kot_id', $this->kot->id)->update([
            'status' => 'ready'
           ]);
        }

        $this->dispatch('refreshKots');
    }

    public function changeKotItemStatus($itemId, $status)
    {
        KotItem::where('id', $itemId)->update([
            'status' => $status
        ]);

        $checkAllItemsReady = KotItem::where('kot_id', $this->kot->id)->where(function($query) {
            $query->where('status', 'cooking')->orWhere('status', null);
        })->count();
        

        if ($checkAllItemsReady == 0) {
            $this->kot->status = 'food_ready';
            $this->kot->save();
        }

        $this->dispatch('refreshKots');
    }

    public function deleteKot($id)
    {
        $order = Kot::find($id)->order;
        $kotCounts = $order->kot->count();
        
        if ($kotCounts == 1) {
            $order->status = 'canceled';
            $order->save();

            if ($order->table) {
                $order->table->update(['available_status' => 'available']);
            }
        }

        Kot::destroy($id);
        $this->confirmDeleteKotModal = false;
        
        $this->dispatch('refreshKots');

        if ($kotCounts == 1) {
            $order->delete();
        }
    }

    public function render()
    {
        return view('livewire.kot.kot-card');
    }

}
